TITLE   'Oppositely Charged Metal Rods' 			{ exa112.pde }
SELECT     errlim=3e-4     ngrid=1     spectral_colors	
VARIABLES   U					
DEFINITIONS							
   L=1     r0=0.1     y0=0.15     U2=1e3
   eps0=8.854e-12     epsr=7.0     eps=epsr*eps0
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Dex=eps*Ex     Dey=eps*Ey     D=eps*E     Dm=magnitude(D)	
   Q=line_integral( normal( D), 'rod1')	{ Line integral over rod1 }
   Fy=Q^2/(2*pi*2*y0)/ eps			{ Elementary force estimate }
EQUATIONS
   div( D)=0	      				
BOUNDARIES
region 'glass' start(-L,-L) natural(U)=0
   line to (0,-L) to (L,-L)  to (L,L) to (-L,L)  close
   start 'rod1' (r0,-y0) value(U)=0			{ Exclude }
   arc( center=0,-y0) angle=360
   start 'rod2' (r0,y0) value(U)=U2
   arc( center=0,y0) angle=360
PLOTS
   grid(x,y) zoom(-3*y0,-3*y0, 6*y0,6*y0)
   contour( U)     contour( Dm) painted zoom(-3*y0,-3*y0, 6*y0,6*y0)
   vector( D) norm zoom(-3*y0,-3*y0, 6*y0,6*y0)
   elevation( normal(D)) on 'rod1'			{ ? Charge on rod 1 }
   elevation( normal(D)) on 'rod2'			{ ? Charge on rod 2 }
   elevation( 0.5*normal(D)*Ey) on 'rod1'	{ ? Force on rod 1 }
   elevation( 0.5*normal(D)*Ey) on 'rod2'	{ ? Force on rod 2}
   report(Fy) as 'Fy_elementary'    		{ Estimate of force }
END


